#ifndef __C_NETWORKLAYERPARAM_H
#define __C_NETWORKLAYERPARAM_H

#define WIN32_LEAN_AND_MEAN

#include <winsock2.h>

#define	DEFAULT_BROADCAST_PORT	10475
#define DEFAULT_UNRELIABLE_PORT	10476
#define DEFAULT_MULTICAST_PORT	10477

/*
 * cNetworkLayerParam.h
 *
 * Parameter set for the network layer.
 */
class cNetworkLayerParam : public cParam
{
  public:

	// Network Options
	static const unsigned int UNRELIABLE_POINT_TO_POINT;
	static const unsigned int UNRELIABLE_BROADCAST;
	static const unsigned int UNRELIABLE_MULTICAST;
	static const unsigned int RELIABLE_POINT_TO_POINT;

	cNetworkLayerParam() { ResetToDefault(); }

	void ResetToDefault()
	{
		mNetworkOptions		= 0;
		mSubnetMask			= cIPEndpoint::DEFAULT_SUBNET_MASK;
		mUnreliablePort		= DEFAULT_UNRELIABLE_PORT;
		mBroadcastPort		= DEFAULT_BROADCAST_PORT;
		mMulticastPort		= DEFAULT_MULTICAST_PORT;
		mRecvOwnMulticasts	= true;
	}

	// Values
	unsigned int	mNetworkOptions;	// Bitfield

	__int32		mSubnetMask;

	// Unreliable point-to-point
	u_short		mUnreliablePort;

	// Unreliable Broadcast
	u_short		mBroadcastPort;

	// Unreliable Multicast
	u_short			mMulticastPort;
	cIPEndpoint*	mMulticastGroup;
	bool			mRecvOwnMulticasts;


};

#endif